package ibase.webitm.ejb.fin;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.utility.ITMException;

/**
 * Session Bean implementation class RetainerContractRelaseIC
 */
@Stateless
public class RetainerContractIC extends ValidatorEJB implements RetainerContractICRemote, RetainerContractICLocal {

    /**
     * Default constructor. 
     */
    public RetainerContractIC() {
    }
    E12GenericUtility genericUtility = new E12GenericUtility();
    
    /**
	 * The public method is used for converting the current form data into a document(DOM)
	 * The dom is then given as argument to the overloaded function wfValData to perform validation
	 * Returns validation string if exists else returns null in XML format
	 * @param xmlString contains the current form data in XML format
	 * @param xmlString1 contains all the header information in the XML format
	 * @param xmlString2 contains the data of all the forms in XML format
	 * @param objContext represents the form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
    public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
    {
    	Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String retString = "";
		try
		   {
			   if(xmlString != null && xmlString.trim().length() > 0)
			   {
				  dom =  genericUtility.parseString(xmlString);
			   }
			   if(xmlString1 != null && xmlString1.trim().length() > 0)
			   {
				   dom1 = genericUtility.parseString(xmlString1);
			   }
			   if(xmlString2 != null && xmlString2.trim().length() > 0)
			   {
				   dom2 = genericUtility.parseString(xmlString2);
			   }
			   retString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			   
			   System.out.println("retString:::"+retString);
		   }
		   catch(Exception e)
		   {
			   System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());			  
			   e.printStackTrace();
				throw new ITMException(e);
		   }
		   return retString;
	}
    /**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currFormDataDom contains the current form data as a document object model
	 * @param hdrDataDom contains all the header information
	 * @param allFormDataDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("******* Inside Retainer Contract wfValData **********");
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		Connection conn = null;
		E12GenericUtility genericUtility;
		String errString = "", userId = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String siteCode = ""; 
		String contractDateStr = ""; 
		String descr = "";
		String cycleTimeStr = "";
		String status = "";
		String amountStr = "";
		String projCode = "";
		String sundryCode = "";
		String sundryType = "";
		String blackListCust = "";
		String blackListSup = "";
		String effDateStr = "";
		String validUptoStr = "";
		String currCode = "";
		String taxClass = "";
		String taxChap = "";
		String taxEnv = "";
		String acctCodeArAp = "";
		String cctrCodeArAp = "";
		String crTerm = "";
		String bankCode = "";		
		String acctCode = "";
		String cctrCode = "";
		String empCode = "";
		String amtType = "";
		String analCode = "";
		String analCode1 = "";
		String analCode2 = "";
		String deptCode = "";
		String projCodes = "";
		String payableReceivable = "";
		double amount = 0.0;
		Timestamp contractDate = null, effDate = null, validUpto = null;
		FinCommon finCommon = null;
		String rndOff = "";//Added by Rohini T on 03/06/2021
		double rndTo=0;
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
		try
		{
			int currentFormNo = 0, childNodeListLength = 0, ctr = 0, cnt = 0;
			String childNodeName = "", errorType = "", errCode = "";
			ArrayList<String> errList = new ArrayList<String>();
			ArrayList<String> errFields = new ArrayList<String>();
			conn = getConnection();
			genericUtility = new E12GenericUtility();	
			finCommon = new FinCommon();
			//SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			System.out.println("xtraParam----->>["+xtraParams+"]");
			System.out.println("editFlag ------------>>["+editFlag+"]");
			if (objContext != null && objContext.trim().length() > 0) 
			{
				currentFormNo  = Integer.parseInt(objContext);
			}	
			switch (currentFormNo)  
			{
			case 1:
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength  = childNodeList.getLength();
				for (ctr = 0; ctr < childNodeListLength; ctr++) 
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					payableReceivable = checkNull(genericUtility.getColumnValue("payable_receivable", dom));
					System.out.println(">>>>>>payableReceivable in Val::["+payableReceivable+"]");
					if (childNodeName.equalsIgnoreCase("site_code"))
					{
						siteCode = checkNull(genericUtility.getColumnValue("site_code", dom));						
						sql = "select count(*) as cnt from site where site_code = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, siteCode);
						rs = pstmt.executeQuery();
						if (rs.next()) 
						{
							cnt = rs.getInt("cnt");
						}	
						pstmt.close();
						rs.close();
						pstmt = null;
						rs = null;
						System.out.println("Inside wfval siteCode>>>["+siteCode+"]");
						if (cnt != 0 ) 
						{
							contractDateStr = checkNull(genericUtility.getColumnValue("contract_date", dom));
							//errcode = nvo_functions_adv.nf_check_period('FIN',mdate1,mVal)
							
						}else{
							errList.add("VMSITE1");
							errFields.add(childNodeName.toLowerCase());
						}
					}
					else if (childNodeName.equalsIgnoreCase("descr"))
					{
						descr = checkNull(genericUtility.getColumnValue("descr", dom));
						if (descr == null || descr.trim().length() == 0) 
						{
							errList.add("VMDESCR");
							errFields.add(childNodeName.toLowerCase());
						}
					}
					else if (childNodeName.equalsIgnoreCase("cycle_time"))
					{
						cycleTimeStr = checkNull(genericUtility.getColumnValue("cycle_time", dom));
						if (cycleTimeStr == null || cycleTimeStr.trim().length() == 0) 
						{
							errList.add("VTCYCTM");
							errFields.add(childNodeName.toLowerCase());
						}
						
					}
					else if (childNodeName.equalsIgnoreCase("amount"))
					{
						amountStr = checkNull(genericUtility.getColumnValue("amount", dom));
						if (amountStr == null || amountStr.trim().length() == 0) 
						{
							errList.add("VTAMTNL");
							errFields.add(childNodeName.toLowerCase());
						}
					}//commented for not set in itemchange
					/*else if (childNodeName.equalsIgnoreCase("status"))
					{
						status = checkNull(genericUtility.getColumnValue("status", dom));
						if (status == null || status.trim().length() == 0) 
						{
							errList.add("VTSTATUSCD");
							errFields.add(childNodeName.toLowerCase());
						}
					}*/
					else if (childNodeName.equalsIgnoreCase("proj_code"))
					{
						projCode = checkNull(genericUtility.getColumnValue("proj_code", dom));
						
						if ( projCode != null && projCode.trim().length() > 0) 
						{
							sql = " select count(*) as cnt from project where proj_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, projCode);
							rs = pstmt.executeQuery();
							if (rs.next()) 
							{
								cnt = rs.getInt("cnt");
							}
							pstmt.close();
							rs.close();
							pstmt = null;
							rs = null;
							System.out.println("Inside wfval projCode>>>["+projCode+"]");
							if(cnt == 0)
							{
								 // Invalid financial entity.				                
				                errList.add("VMPROJ1");
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}
					else if (childNodeName.equalsIgnoreCase("sundry_code"))
					{						
						sundryCode = checkNull(genericUtility.getColumnValue("sundry_code", dom));						
						if ( sundryCode == null || sundryCode.trim().length() == 0) 
						{
							if(!("J".equalsIgnoreCase(payableReceivable)))
							{
								errList.add("VTACCTCD1");
								errFields.add(childNodeName.toLowerCase());
							//goto hdr_error
							}
						}else
						{
							sundryType = checkNull(genericUtility.getColumnValue("sundry_type", dom));
							if("C".equalsIgnoreCase(sundryType))
							{
								sql = " select count(*) as cnt from customer where cust_code = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, sundryCode);
								rs = pstmt.executeQuery();
								if (rs.next()) 
								{
									cnt = rs.getInt("cnt");
								}
								pstmt.close();
								rs.close();
								pstmt = null;
								rs = null;
								System.out.println("Inside wfval projCode>>>["+projCode+"]"); 
								if(cnt == 0)
								{								
									errList.add("VMCUST1");
									errFields.add(childNodeName.toLowerCase());
								}
								else
								{
									sql = " select black_listed from customer where cust_code = ?";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, sundryCode);
									rs = pstmt.executeQuery();
									if (rs.next()) 
									{
										blackListCust = checkNull(rs.getString("black_listed"));
									}
									pstmt.close();
									rs.close();
									pstmt = null;
									rs = null;
									if("Y".equalsIgnoreCase(blackListCust))
									{
										errList.add("VTCUSTCD6");
										errFields.add(childNodeName.toLowerCase());
									}
								}
							}
							else if("S".equalsIgnoreCase(sundryType))
							{
								sql = "select count(*) as cnt from supplier where supp_code = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, sundryCode);
								rs = pstmt.executeQuery();
								if (rs.next()) 
								{
									cnt = rs.getInt("cnt");
								}
								pstmt.close();
								rs.close();
								pstmt = null;
								rs = null;
								if(cnt == 0)
								{
									// Invalid supplier.				                
					                errList.add("VMSUPP1");
									errFields.add(childNodeName.toLowerCase());
								}
								else
								{
									sql = "Select black_list from supplier where supp_code = ? ";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, sundryCode);
									rs = pstmt.executeQuery();
									if (rs.next()) 
									{
										blackListSup = checkNull(rs.getString("black_list"));
									}
									pstmt.close();
									rs.close();
									pstmt = null;
									rs = null;
									if("Y".equalsIgnoreCase(blackListSup))
									{
										//supplier block listed.				                
						                errList.add("VTSUPPBL");
										errFields.add(childNodeName.toLowerCase());											
									}
								}
							}
						}//else end
					}
					else if (childNodeName.equalsIgnoreCase("eff_date"))
					{
						effDateStr = checkNull(genericUtility.getColumnValue("eff_date", dom));
						effDate = Timestamp.valueOf(genericUtility.getValidDateString(effDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
						validUptoStr = checkNull(genericUtility.getColumnValue("valid_upto", dom));
						validUpto = Timestamp.valueOf(genericUtility.getValidDateString(validUptoStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
						//if(validUpto.compareTo(effDate) < 0)
						//if(validUptoStr.compareTo(effDateStr) < 0)
						if(validUpto != null)
						{
							if(validUpto.before(effDate))
							{
								//effective date is less than valid date
								errList.add("VTDATE6");
								errFields.add(childNodeName.toLowerCase());	
							}
						}else
						{
							errList.add("VLDUPTNUL ");
							errFields.add(childNodeName.toLowerCase());	
						}
					}
					else if (childNodeName.equalsIgnoreCase("curr_code"))
					{						
						currCode = checkNull(genericUtility.getColumnValue("curr_code", dom));
						if ( currCode == null || currCode.trim().length() == 0) 
						{
							// Empty currency code.
							errList.add("VECUR2");
							errFields.add(childNodeName.toLowerCase());
						}
						else
						{
							sql = "select count(*) as cnt from currency where curr_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, currCode);
							rs = pstmt.executeQuery();
							if (rs.next()) 
							{
								cnt = rs.getInt("cnt");
							}
							pstmt.close();
							rs.close();
							pstmt = null;
							rs = null;
							if(cnt == 0)
							{
								// Invalid currency.				                			               
				                errList.add("VMCUR1");
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}					
					else if (childNodeName.equalsIgnoreCase("tax_class"))
					{
						taxClass = checkNull(genericUtility.getColumnValue("tax_class", dom));
						if (taxClass != null && taxClass.trim().length() > 0) 
						{
							sql = "select count(*) as cnt from taxclass where tax_class = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, taxClass);
							rs = pstmt.executeQuery();
							if (rs.next()) 
							{
								cnt = rs.getInt("cnt");
							}
							pstmt.close();
							rs.close();
							pstmt = null;
							rs = null;
							if(cnt == 0)
							{
								// Invalid Tax Class				                			               
				                errList.add("VMTACLA1");
								errFields.add(childNodeName.toLowerCase());
							}
						}
						
					}
					else if (childNodeName.equalsIgnoreCase("tax_chap"))
					{						
						taxChap = checkNull(genericUtility.getColumnValue("tax_chap", dom));
						if (taxChap != null && taxChap.trim().length() > 0) 
						{
							sql = "select count(*) as cnt from taxchap where tax_chap = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, taxChap);
							rs = pstmt.executeQuery();
							if (rs.next()) 
							{
								cnt = rs.getInt("cnt");
							}
							pstmt.close();
							rs.close();
							pstmt = null;
							rs = null;
							if(cnt == 0)
							{
								 // Invalid tax chapter.			                			               
				                errList.add("VMTACHA1");
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}					
					else if (childNodeName.equalsIgnoreCase("tax_env"))
					{						
						taxEnv = checkNull(genericUtility.getColumnValue("tax_env", dom));
						if (taxEnv != null && taxEnv.trim().length() > 0) 
						{
							sql = " select count(*) as cnt from taxenv where tax_env = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, taxEnv);
							rs = pstmt.executeQuery();
							if (rs.next()) 
							{
								cnt = rs.getInt("cnt");
							}
							pstmt.close();
							rs.close();
							pstmt = null;
							rs = null;
							if(cnt == 0)
							{
								// Invalid tax environment.			                			               
				                errList.add("VMTAENV1");
								errFields.add(childNodeName.toLowerCase());
							}
							else
							{
								//to check taxenv closed status.					 
								contractDateStr = checkNull(genericUtility.getColumnValue("contract_date", dom));  								
								contractDate = Timestamp.valueOf(genericUtility.getValidDateString(contractDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
								//Pavan R 17sept19 start[to validate tax environment]
								//errCode = finCommon.checkTaxEnvStatus(taxEnv, contractDate, conn);
								errCode = finCommon.checkTaxEnvStatus(taxEnv, contractDate, "E", conn);
								//Pavan R 17sept19 end[to validate tax environment]
								System.out.println("#### checkTaxEnvStatus::errCode["+errCode+"]");
								if (errCode != null && errCode.trim().length() > 0)
								{								
									errList.add(checkNull(errCode));
									errFields.add(childNodeName.toLowerCase());
								}								
							}
						}
					} 					
					else if (childNodeName.equalsIgnoreCase("acct_code__arap"))
					{						
						acctCodeArAp = checkNull(genericUtility.getColumnValue("acct_code__arap", dom));
						siteCode = checkNull(genericUtility.getColumnValue("site_code", dom));
						 //errcode = nvo_retcont.gbf_acct(mVal1,mVal,transer)
						// To check acct code in account master and whether it is active or not
						errCode = finCommon.isAcctCode(siteCode, acctCodeArAp, " ", conn);
						
						sundryCode = checkNull(genericUtility.getColumnValue("sundry_code", dom));
						sundryType = checkNull(genericUtility.getColumnValue("sundry_type", dom));
						if ( errCode == null || errCode.trim().length() == 0 )							
						{
							//errcode = nvo_retcont.gbf_acct_type(mval, sundryCode, sundryType)
							errCode = finCommon.isAcctType(acctCodeArAp, sundryCode, sundryType, conn);							
						}
						if ( errCode != null && errCode.trim().length() > 0 )
						{
							errList.add(checkNull(errCode));
							errFields.add(childNodeName.toLowerCase());
						}
					}
					else if (childNodeName.equalsIgnoreCase("cctr_code__arap"))
					{						
						cctrCodeArAp = checkNull(genericUtility.getColumnValue("cctr_code__arap", dom));
						acctCodeArAp = checkNull(genericUtility.getColumnValue("acct_code__arap", dom));
						//errcode = nvo_retcont.gbf_cctr(mVal1,mVal,transer)
						errCode = finCommon.isCctrCode(acctCodeArAp, cctrCodeArAp, " ", conn);
						if ( errCode != null && errCode.trim().length() > 0 )
						{
							errList.add(checkNull(errCode));
							errFields.add(childNodeName.toLowerCase());	
						}
					}
					else if (childNodeName.equalsIgnoreCase("cr_term"))
					{		
						if(!("J".equalsIgnoreCase(payableReceivable)))
						{
							crTerm = checkNull(genericUtility.getColumnValue("cr_term", dom));
							sql = " select count(*) as cnt from crterm where cr_term =  ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, crTerm);
							rs = pstmt.executeQuery();
							if (rs.next()) 
							{
								cnt = rs.getInt("cnt");
							}
							pstmt.close();
							rs.close();
							pstmt = null;
							rs = null;
							if(cnt == 0)
							{
								//Credit Term Not Found!
				                errList.add("VTCRTERM1");
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}
					else if (childNodeName.equalsIgnoreCase("bank_code"))
					{						
						bankCode = checkNull(genericUtility.getColumnValue("bank_code", dom));
						if(bankCode == null || bankCode.trim().length() == 0)
						{
							//Invalid bank code.
			                errList.add("VMBANK1");
							errFields.add(childNodeName.toLowerCase());
						}
					}
					//Modified by Rohini T on 03/06/2021[Start]
					else if (childNodeName.equalsIgnoreCase("rnd_off")) 
					{
						rndOff = genericUtility.getColumnValue("rnd_off", dom);
						rndTo = Double.parseDouble(genericUtility.getColumnValue("rnd_to", dom));
						System.out.println("rndOff..."+rndOff+"...rndTo.."+rndTo);
						if(!("N".equalsIgnoreCase(rndOff)))
						{
							if(rndTo <= 0) 
							{
								errCode = "VTMPAYRNDT";//Round To Cannot be Zero
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}
					
					
					//Modified by Rohini T on 03/06/2021[End]
				}//end of for loop
				break;// end of switch
				// case2
				case 2:
					System.out.println("---------------in detail2 validation------------------------");
					System.out.println("dom@@@@------->>" + genericUtility.serializeDom(dom));
					System.out.println("dom@@@@111------->>" + genericUtility.serializeDom(dom1));
					System.out.println("dom@@@@222------->>" + genericUtility.serializeDom(dom2));
					parentNodeList = dom.getElementsByTagName("Detail2");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for (ctr = 0; ctr < childNodeListLength; ctr++) {
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						if (childNodeName.equalsIgnoreCase("acct_code")) 
						{
							siteCode = checkNull(genericUtility.getColumnValue("site_code", dom1));
							//acctCode = checkNull(genericUtility.getColumnValue("acct_code", dom, "2"));
							//System.out.println("@Arti dom, 2 acctCode:["+acctCode+"]");
							//Arti: 11-May-24: Pick the value from parentNode to avaid the tax details clash
							acctCode = checkNull(genericUtility.getColumnValueFromNode("acct_code", parentNode));
							System.out.println("@Arti parentNode acctCode:["+acctCode+"]");

							System.out.println("siteCode:["+siteCode+"]acctCode:["+acctCode+"]");
							errCode =  finCommon.isAcctCode(siteCode, acctCode, "", conn);
							if(errCode == null || errCode.trim().length() == 0)
							{
								errCode = finCommon.isAcctType(acctCode, "", "", conn);
								if(errCode != null && errCode.trim().length() > 0)
								{
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());									
								}
							}
							else
							{
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
						else if (childNodeName.equalsIgnoreCase("cctr_code")) 
						{
							//cctrCode = checkNull(genericUtility.getColumnValue("cctr_code", dom));
							cctrCode = checkNull(genericUtility.getColumnValueFromNode("cctr_code", parentNode));
							//acctCode = checkNull(genericUtility.getColumnValue("acct_code", dom));
							errCode = finCommon.isCctrCode(acctCode, cctrCode, "", conn);
							if(errCode != null && errCode.trim().length() > 0)
							{
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());									
							}
						}
						else if (childNodeName.equalsIgnoreCase("emp_code")) 
						{
							empCode = checkNull(genericUtility.getColumnValue("emp_code", dom));
							siteCode = checkNull(genericUtility.getColumnValue("site_code", dom1));
							System.out.println("siteCode:["+siteCode+"]empCode:["+empCode+"]");
							errCode = finCommon.isEmployee(siteCode, empCode, "", conn);
							if(errCode != null && errCode.trim().length() > 0)
							{
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());									
							}
						}
						else if (childNodeName.equalsIgnoreCase("amt_type")) 
						{
							//P-percentage & F-fixed
							amtType = checkNull(genericUtility.getColumnValue("amt_type", dom));
							if ("P".equalsIgnoreCase(amtType))
							{
								amount = Double.parseDouble(genericUtility.getColumnValue("amount", dom));
								if ( amount > 100 )
								{		
									//Invalid amount for percentage
									errList.add("VTCTYPE");
									errFields.add(childNodeName.toLowerCase());
								}
					               
								
							}
						}
						else if (childNodeName.equalsIgnoreCase("anal_code")) 
						{
							analCode = checkNull(genericUtility.getColumnValue("anal_code", dom));
							//acctCode = checkNull(genericUtility.getColumnValue("acct_code", dom));
							acctCode = checkNull(genericUtility.getColumnValueFromNode("acct_code", parentNode));
							errCode = finCommon.isAnalysis(acctCode, analCode, "", conn);
							if(errCode != null && errCode.trim().length() > 0)
							{
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());									
							}
						}
						else if (childNodeName.equalsIgnoreCase("anal_code__1")) 
						{
							analCode1 = checkNull(genericUtility.getColumnValue("anal_code__1", dom));
							//acctCode = checkNull(genericUtility.getColumnValue("acct_code", dom));
							acctCode = checkNull(genericUtility.getColumnValueFromNode("acct_code", parentNode));
							errCode = finCommon.isAnalysis(acctCode, analCode1, "", conn);
							if(errCode != null && errCode.trim().length() > 0)
							{
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());									
							}
						}
						else if (childNodeName.equalsIgnoreCase("anal_code__2")) 
						{
							analCode2 = checkNull(genericUtility.getColumnValue("anal_code__2", dom));
							//acctCode = checkNull(genericUtility.getColumnValue("acct_code", dom));
							acctCode = checkNull(genericUtility.getColumnValueFromNode("acct_code", parentNode));
							errCode = finCommon.isAnalysis(acctCode, analCode2, "", conn);
							if(errCode != null && errCode.trim().length() > 0)
							{
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());									
							}
						}
						else if (childNodeName.equalsIgnoreCase("dept_code")) 
						{
							deptCode = checkNull(genericUtility.getColumnValue("dept_code", dom));
							//acctCode = checkNull(genericUtility.getColumnValue("acct_code", dom));
							acctCode = checkNull(genericUtility.getColumnValueFromNode("acct_code", parentNode));
							if(deptCode != null && deptCode.trim().length() > 0)
							{
								errCode = isAcctDept(acctCode, deptCode, "", conn);
								if(errCode != null && errCode.trim().length() > 0)
								{
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());									
								}								
							}
						}
						else if (childNodeName.equalsIgnoreCase("proj_code")) 
						{
							projCodes = checkNull(genericUtility.getColumnValue("proj_code", dom));
							if (projCodes != null && projCodes.trim().length() > 0 ) 
							{
								sql = " select count(*) as cnt from project where proj_code = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, projCodes);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									cnt = rs.getInt("cnt");
								}
								pstmt.close();
								rs.close();
								pstmt = null;
								rs = null;
								if(cnt == 0)
								{
									// Invalid Project code.								
					                errList.add("VMPROJ1");
									errFields.add(childNodeName.toLowerCase());	
								}
							}
						}
						//Pavan R 17sept19 start[to validate tax environment]
						else if (childNodeName.equalsIgnoreCase("tax_env"))
						{						
							//taxEnv = checkNull(genericUtility.getColumnValue("tax_env", dom));
							taxEnv = checkNull(getParentColumnValue("tax_env", dom, "2"));
							System.out.println("RC 2 taxEnv["+taxEnv+"]");
							if (taxEnv != null && taxEnv.trim().length() > 0) 
							{
								sql = " select count(*) as cnt from taxenv where tax_env = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, taxEnv);
								rs = pstmt.executeQuery();
								if (rs.next()) 
								{
									cnt = rs.getInt("cnt");
								}
								pstmt.close();
								rs.close();
								pstmt = null;
								rs = null;
								if(cnt == 0)
								{
									// Invalid tax environment.			                			               
					                errList.add("VMTAENV1");
									errFields.add(childNodeName.toLowerCase());
								}
								else
								{
									contractDateStr = checkNull(genericUtility.getColumnValue("contract_date", dom1));  								
									contractDate = Timestamp.valueOf(genericUtility.getValidDateString(contractDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");																
									errCode = finCommon.checkTaxEnvStatus(taxEnv, contractDate, "E", conn);							
									System.out.println("#### checkTaxEnvStatus::errCode["+errCode+"]");
									if (errCode != null && errCode.trim().length() > 0)
									{								
										errList.add(checkNull(errCode));
										errFields.add(childNodeName.toLowerCase());
									}								
								}
							}
						}
						//Pavan R 17sept19 end[to validate tax environment]
					}// for loop end
					break;	
					//Added new case by amol on 19-March for the validation on assetcode pophelp --start
				case 3:
					System.out.println("----------Detail3 test validation Test 20-03::------------------------");
					System.out.println("dom@@@@------->>" + genericUtility.serializeDom(dom));
					System.out.println("dom@@@@111------->>" + genericUtility.serializeDom(dom1));
					System.out.println("dom@@@@222------->>" + genericUtility.serializeDom(dom2));
					int count = 0;
					String errorString="";

					parentNodeList = dom.getElementsByTagName("Detail3");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					
					for (ctr = 0; ctr < childNodeListLength; ctr++) {
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						 if (childNodeName.equalsIgnoreCase("asset_code")) {
							 
							 
	                        BaseLogger.log("3", null, null, " Inside the else block-->");
	                       
	                        System.out.println("DOM in case 3 :::---->>["+genericUtility.serializeDom(dom).toString()+"]");

		                    String assetCode = checkNull(genericUtility.getColumnValue("asset_code", dom));
		    		        BaseLogger.log("3", null, null, "Asset Code --->	"+assetCode );

	                       try {
	                             sql = "SELECT COUNT (ASSET_CODE) FROM ASSET_REGISTER WHERE ASSET_CODE = ?";

	                             pstmt = conn.prepareStatement(sql);
	                             pstmt.setString(1, assetCode);
	                            rs = pstmt.executeQuery();
	                            if (rs.next()) {
	                            	//count = rs.getInt("COUNT");
	                            	count = rs.getInt(1);
	                            }
	                            if (count <= 0) {
	                                errorString = getErrorString("asset_code", "INVLDASTCD", userId);
	                            }
	                        } catch (SQLException e) {
	                            BaseLogger.log("3", null, null,
	                                    "Catch block of asset_code pophelp validation" + e.getMessage());
	                            e.printStackTrace();
	                        }
	                       break;  
	                    }
					}
					
						
					return errorString;	

					
			//Added new case by amol on 19-March for the validation on assetcode pophelp --End

			}// end of switch
			int errListSize = errList.size();
			int count = 0;
			String errFldName = null;
			if (errList != null && errListSize > 0) 
			{
				for (count = 0; count < errListSize; count++) {
					errCode = errList.get(count);
					errFldName = errFields.get(count);
					System.out.println(" testing :errCode .:" + errCode);
					errString = getErrorString(errFldName, errCode, userId);
					errorType = errorType(conn, errCode);
					if (errString.length() > 0) {
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8,
								errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8,
								errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if (errorType.equalsIgnoreCase("E")) {
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			} else {
				errStringXml = new StringBuffer("");
			}
		}catch ( Exception e )
		{
			System.out.println ( "Exception: RetainerContract: wfValData( Document currFormDataDom ): " + e.getMessage() + ":" );
			e.printStackTrace();
			throw new ITMException(e);
		}
		//Add by Ajay on 02/05/18:START
				finally {
					try {
						if (conn != null) {
							if (rs != null) {
								rs.close();
								rs = null;
							}
							if (pstmt != null) {
								pstmt.close();
								pstmt = null;
							}
							conn.close();
						}
						conn = null;
					} catch (Exception d) {
						d.printStackTrace();
						throw new ITMException(d);
					}
				}
				//Add by Ajay on 02/05/18:END
		
		return errStringXml.toString();
	}
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String retString = "";
		E12GenericUtility genericUtility = new E12GenericUtility();
		System.out.println("In Itemchange String:::");

		try {
			System.out.println("xmlString::["+xmlString+"]\nxmlString1::["+xmlString1+"]\nxmlString2::["+xmlString2+"]");
			if (xmlString != null && xmlString.trim().length() > 0) {
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() > 0) {
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() > 0) {
				dom2 = genericUtility.parseString(xmlString2);
			}
			retString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		} catch (Exception e) {
			System.out.println(":::" + this.getClass().getSimpleName() + "::" + e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	public String itemChanged(Document dom, Document dom1, Document dom2,String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Connection conn = null;
		String sql = "", descr = "", sundryCode="", sundryType="", payableReceivable="", description="",description1="",description2="",description3="",
				dateNow="", rndStr="", rndOff="", tranSer="", siteCode="",SiteDescr="",bankCode="",bankName="", projCode="";
		String  crTerm="", creditPrd="" ,payMode="", empFName="", empLName="", sundryName="",
				accountsDescr="", currencyDescr="", currCode="",acctCode="",cctrCode="",acctCodeArAp="",lineNo="",
				contractId="",taxClass="",taxChap="",taxEnv="",empCode="",deptCode="", fName="", lName="", mName="";
		String stnTo = "", stnFr = "",contractDateStr="";
		
		String logInEmpCode ="";//Added By PriyankC on15MAY2018 to set bydefault empCode.
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		StringBuffer valueXmlString = new StringBuffer();
		int currentFormNo = 0, ctr = 0, crDays=0;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		Timestamp currentDate= null;
		FinCommon finCommon = null;
		DistCommon distCommon = null;
		String payRndOff="",payRndTo="";
		try {
			System.out.println("----------------Inside itemChanged test-------------------");
			distCommon = new DistCommon();
			finCommon = new FinCommon();	
			conn = getConnection();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			currentDate = new Timestamp(System.currentTimeMillis());
			dateNow = (sdf.format(currentDate).toString()).trim();
			
			//currentDate = Timestamp.valueOf(genericUtility.getValidDateString(String.valueOf(new Timestamp(System.currentTimeMillis())), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
			//Calendar currentDate1 = Calendar.getInstance();
			System.out.println("currentDate is::"+dateNow);
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
			valueXmlString.append(editFlag).append("</editFlag> </header>");		
			switch (currentFormNo) 
			{
				case 1 : parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail1>");
				ctr = 0;
				int childNodeListLength = childNodeList.getLength();
				do
				{   
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(currentColumn))
					{
						if(childNode.getFirstChild() != null)
						{
						}
					}
					ctr ++;
			    }while(ctr < childNodeListLength  && ! childNodeName.equals(currentColumn));				
				if(currentColumn.trim().equalsIgnoreCase("itm_defaultedit"))
				{
					sundryCode = checkNullAndTrim(genericUtility.getColumnValue("sundry_code", dom));
					sundryType = checkNull(genericUtility.getColumnValue("sundry_type", dom));
					
					if("C".equalsIgnoreCase(sundryType))
					{
						description = findValue(conn, "cust_name" , "customer", "cust_code", sundryCode);
					}
					else if("S".equalsIgnoreCase(sundryType))
					{ 
						description = findValue(conn, "supp_name" , "supplier", "supp_code", sundryCode);
					}
					else if("E".equalsIgnoreCase(sundryType))
					{ 
						description1 = findValue(conn, "emp_fname" , "employee", "emp_code", sundryCode);
						description2 = findValue(conn, "emp_lname" , "employee", "emp_code", sundryCode);
						description = description1.trim() + " " +  description2.trim();
					}
					else if("P".equalsIgnoreCase(sundryType))
					{ 
						description = findValue(conn, "sp_name" ,"sales_pers", "sales_pers", sundryCode);
					}
					else if("T".equalsIgnoreCase(sundryType))
					{ 
						description = findValue(conn, "tran_name" , "transporter", "tran_code", sundryCode);
					}
					else if("X".equalsIgnoreCase(sundryType))
					{ 
						description = findValue(conn, "tauth_name" , "tax_authority", "tauth_code", sundryCode);
					}
					else if("L".equalsIgnoreCase(sundryType))
					{ 
						description = findValue(conn, "party_name" , "loanparty", "party_code", sundryCode);
					}
					else if("R".equalsIgnoreCase(sundryType))
					{
						description1 = findValue(conn, "first_name" , "strg_customer", "sc_code", sundryCode);
						description2 = findValue(conn, "middle_name" , "strg_customer", "sc_code", sundryCode);
						description3 = findValue(conn, "last_name" , "strg_customer", "sc_code", sundryCode);
						description = description1.trim() + " " +  description2.trim() + "" + description3.trim();
					}
					valueXmlString.append("<sundry_name>").append("<![CDATA[" + description + "]]>").append("</sundry_name>");
					//setNodeValue(dom, "sundry_name", description);
					
					String dateLastProcStr = checkNull(genericUtility.getColumnValue("date__last_proc", dom));
					contractDateStr = checkNull(genericUtility.getColumnValue("contract_date", dom));
					String effectiveDateStr = checkNull(genericUtility.getColumnValue("eff_date", dom));//Added by Ashwini p oon 14-Mar-23
					if (dateLastProcStr != null && dateLastProcStr.trim().length() > 0)
					{						
						valueXmlString.append("<eff_date protect = \"1\">").append("<![CDATA[]]>").append("</eff_date>");

					}else
					{						
					//	valueXmlString.append("<eff_date protect = \"0\">").append("<![CDATA[" + contractDateStr + "]]>").append("</eff_date>");
						valueXmlString.append("<eff_date protect = \"0\">").append("<![CDATA[" + effectiveDateStr + "]]>").append("</eff_date>");//Added by Ashwini p on 14-Mar-23
					}
				}else if(currentColumn.trim().equalsIgnoreCase("itm_default"))
				{
					System.out.println("----------- inside itm_default ---------------");
					System.out.println("appended Date::"+dateNow);
					valueXmlString.append("<contract_date>").append("<![CDATA[" + dateNow + "]]>").append("</contract_date>");
					valueXmlString.append("<eff_date protect = \"0\">").append("<![CDATA[" + dateNow + "]]>").append("</eff_date>");
					//Modified by Rohini T on 07/06/2021[Start]
				/*	rndStr = tranSer + "-RND";
					rndOff = finCommon.getFinparams("999999", rndStr, conn);
					System.out.println("rndOff..."+rndOff);
					if(!("NULLFOUND".equalsIgnoreCase(rndOff)))
					{
						System.out.println("rndOff...@@@"+rndOff);
						valueXmlString.append("<rnd_off>").append("<![CDATA[" + rndOff + "]]>").append("</rnd_off>");
					
						rndStr = tranSer + "-RNDTO";
						rndOff = finCommon.getFinparams("999999", rndStr, conn);
						System.out.println("rndOff...@@@!"+rndOff);
						if(!("NULLFOUND".equalsIgnoreCase(rndOff)))
						{							
							System.out.println("rndOff...!!!"+rndOff);
							valueXmlString.append("<rnd_to>").append("<![CDATA[" + rndOff + "]]>").append("</rnd_to>");											
						}
					}   */
					payRndOff = finCommon.getFinparams("999999","PAY_RND_OFF",conn);
					System.out.println("payRndOff...."+payRndOff);
					if(payRndOff == null || payRndOff.trim().equals("NULLFOUND"))
	                {
					  System.out.println("payRndOff...."+payRndOff);
		              valueXmlString.append("<rnd_off>").append("<![CDATA[" + "N" + "]]>").append("</rnd_off>");
                      valueXmlString.append("<rnd_to>").append("<![CDATA[" + 0 + "]]>").append("</rnd_to>");
	                }
					else
					{
					  payRndTo = finCommon.getFinparams("999999","PAY_RND_TO",conn);
					  System.out.println("payRndTo from Finparam::: ["+payRndTo+"]");
					  if(payRndTo == null || payRndTo.trim().equals("NULLFOUND") || payRndTo.trim().length() == 0)
		              {
						  payRndTo = "1";
		              }
					  else
					  {
						  try 
						  {
							  payRndTo = Integer.parseInt(payRndTo)+"";
						  } 
						  catch (NumberFormatException nfe) 
						  {
							  payRndTo = "1";
						  }
						  catch (NullPointerException nfe) 
						  {
							  payRndTo = "1";
						  }
					  }
					  System.out.println("payRndTo from Finparam::: ["+payRndTo+"]");  
				      valueXmlString.append("<rnd_off>").append("<![CDATA[" + payRndOff + "]]>").append("</rnd_off>");
                      valueXmlString.append("<rnd_to>").append("<![CDATA[" + payRndTo + "]]>").append("</rnd_to>");
				    }
					//Modified by Rohini T on 07/06/2021[End]
				}
				else if(currentColumn.trim().equalsIgnoreCase("site_code"))
				{
					siteCode = checkNull(genericUtility.getColumnValue("site_code", dom));
					sql = "select descr from site where site_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode);
					rs  = pstmt.executeQuery();
					if(rs.next())
					{
						SiteDescr = checkNull(rs.getString("descr"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					valueXmlString.append("<site_descr>").append("<![CDATA[" + SiteDescr + "]]>").append("</site_descr>");
					
					sql = "select bank_code from site where site_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode);
					rs  = pstmt.executeQuery();
					if(rs.next())
					{
						bankCode = checkNull(rs.getString("bank_code"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					valueXmlString.append("<bank_code>").append("<![CDATA[" + bankCode + "]]>").append("</bank_code>");
					
					if (bankCode != null && bankCode.trim().length() > 0) 
					{
						sql="Select bank_name from bank Where bank_code = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, bankCode.trim());
						rs  = pstmt.executeQuery();
						if(rs.next())
						{
							bankName = checkNull(rs.getString("bank_name"));
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						
						valueXmlString.append("<bank_bank_name>").append("<![CDATA[" + bankName + "]]>").append("</bank_bank_name>");						
					}
					projCode = checkNull(genericUtility.getColumnValue("proj_code", dom));
					if(projCode != null && projCode.trim().length() > 0)
					{
						valueXmlString.append("<proj_code>").append("<![CDATA[" + " " + "]]>").append("</proj_code>");
					}else
					{
						valueXmlString.append("<proj_code>").append("<![CDATA[" + projCode + "]]>").append("</proj_code>");
					}
				}else if(currentColumn.trim().equalsIgnoreCase("sundry_code"))
				{
					sundryCode = checkNullAndTrim(genericUtility.getColumnValue("sundry_code", dom));
					sundryType = checkNull(genericUtility.getColumnValue("sundry_type", dom));
					siteCode = checkNull(genericUtility.getColumnValue("site_code", dom));
					if("C".equalsIgnoreCase(sundryType)) //Customer
					{
						sql = " select cust_name, curr_code, acct_code__ar, cctr_code__ar, cr_term, credit_prd ,rcp_mode, tax_class, tax_chap, stan_code " +
								" from customer where cust_code = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, sundryCode);
						rs  = pstmt.executeQuery();
						if(rs.next())
						{
							sundryName = checkNull(rs.getString("cust_name"));
							currCode = checkNull(rs.getString("curr_code"));
							acctCode = checkNull(rs.getString("acct_code__ar"));
							cctrCode = checkNull(rs.getString("cctr_code__ar"));
							crTerm = checkNull(rs.getString("cr_term"));
							creditPrd = checkNull(rs.getString("credit_prd"));
							payMode = checkNull(rs.getString("rcp_mode"));
							taxClass = checkNull(rs.getString("tax_class"));
							taxChap = checkNull(rs.getString("tax_chap"));
							stnTo = checkNull(rs.getString("stan_code"));
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;	
						
						sql = " select stan_code from site where site_code = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, siteCode);
						rs  = pstmt.executeQuery();
						if(rs.next())
						{
							stnFr = checkNull(rs.getString("stan_code"));
						}
						rs.close();
						rs = null;
						pstmt.close();							
						pstmt = null;	
						System.out.println("-----Pavan-----stnFr["+stnFr+"]stnTo["+stnTo+"]");
						taxEnv = distCommon.getTaxEnv(stnFr, stnTo, taxChap, taxClass, siteCode, conn);
						System.out.println("---C--taxClass["+taxClass+"]taxChap["+taxChap+"]taxEnv["+taxEnv+"]");
					}
					else if("S".equalsIgnoreCase(sundryType)) //Supplier
					{
						sql = "select supp_name, curr_code, acct_code__ap, cctr_code__ap, pay_mode, cr_term, credit_prd, tax_class, tax_chap, tax_env " +
								" from supplier where supp_code = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, sundryCode);
						rs  = pstmt.executeQuery();
						if(rs.next())
						{
							sundryName = checkNull(rs.getString("supp_name"));
							currCode = checkNull(rs.getString("curr_code"));
							acctCode = checkNull(rs.getString("acct_code__ap"));
							cctrCode = checkNull(rs.getString("cctr_code__ap"));
							payMode = checkNull(rs.getString("pay_mode"));
							crTerm = checkNull(rs.getString("cr_term"));
							creditPrd = checkNull(rs.getString("credit_prd"));
							taxClass = checkNull(rs.getString("tax_class"));
							taxChap = checkNull(rs.getString("tax_chap"));
							taxEnv = checkNull(rs.getString("tax_env"));
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						System.out.println("---S--taxClass["+taxClass+"]taxChap["+taxChap+"]taxEnv["+taxEnv+"]");
						valueXmlString.append("<pay_mode>").append("<![CDATA[" + payMode + "]]>").append("</pay_mode>");
					}					
					else if("E".equalsIgnoreCase(sundryType)) //Employee
					{
						String msite="";
						sql = " select a.emp_fname, a.emp_lname, a.acct_code__sal, a.cctr_code__sal, b.site_code__acct, a.pay_mode " +
								" from employee a, site b where a.pay_site = b.site_code and a.emp_code = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, sundryCode);
						rs  = pstmt.executeQuery();
						if(rs.next())
						{
							fName = checkNull(rs.getString("emp_fname"));
							lName = checkNull(rs.getString("emp_lname"));
							acctCode = checkNull(rs.getString("acct_code__sal"));
							cctrCode = checkNull(rs.getString("cctr_code__sal"));
							msite = checkNull(rs.getString("site_code__acct"));
							payMode = checkNull(rs.getString("pay_mode"));							
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						sundryName = fName.trim()+" "+ lName.trim();
						
						sql = " select curr_code from site, finent " +
								" where site.fin_entity = finent.fin_entity " +
								" and site_code = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, siteCode);
						rs  = pstmt.executeQuery();
						if(rs.next())
						{
							currCode = checkNull(rs.getString("curr_code"));							
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;						
						
					}else if("P".equalsIgnoreCase(sundryType)) // Sales Person
					{
						sql = " select sp_name, cr_term, curr_code, acct_code__ap, cctr_code__ap, tax_class, tax_chap, tax_env " +
								" from sales_pers where sales_pers = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, sundryCode);
						rs  = pstmt.executeQuery();
						if(rs.next())
						{
							sundryName = checkNull(rs.getString("sp_name"));
							crTerm = checkNull(rs.getString("cr_term"));
							currCode = checkNull(rs.getString("curr_code"));
							acctCode = checkNull(rs.getString("acct_code__ap"));
							cctrCode = checkNull(rs.getString("cctr_code__ap"));	
							taxClass = checkNull(rs.getString("tax_class"));
							taxChap = checkNull(rs.getString("tax_chap"));
							taxEnv = checkNull(rs.getString("tax_env"));
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						System.out.println("---P--taxClass["+taxClass+"]taxChap["+taxChap+"]taxEnv["+taxEnv+"]");
						if (crTerm != null && crTerm.trim().length() > 0) 
						{
							sql = " Select cr_days from crterm where cr_term = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, crTerm);
							rs  = pstmt.executeQuery();
							if(rs.next())
							{
								creditPrd = checkNull(rs.getString("cr_days"));	
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
					}
					else if("T".equalsIgnoreCase(sundryType)) // Transporter
					{
						sql = " select tran_name, cr_term, credit_prd, curr_code, acct_code__fp,  cctr_code__fp, pay_mode, tax_class, tax_env " +
								" from transporter where tran_code = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, sundryCode);
						rs  = pstmt.executeQuery();
						if(rs.next())
						{
							sundryName = checkNull(rs.getString("tran_name"));
							crTerm = checkNull(rs.getString("cr_term"));
							creditPrd = checkNull(rs.getString("credit_prd"));							
							currCode = checkNull(rs.getString("curr_code"));
							acctCode = checkNull(rs.getString("acct_code__fp"));
							cctrCode = checkNull(rs.getString("cctr_code__fp"));
							payMode = checkNull(rs.getString("pay_mode"));	
							taxClass = checkNull(rs.getString("tax_class"));
							taxEnv = checkNull(rs.getString("tax_env"));
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						taxChap = distCommon.getTaxChap("", "", sundryType, sundryCode, siteCode, conn);
						System.out.println("---T--taxClass["+taxClass+"]taxChap["+taxChap+"]taxEnv["+taxEnv+"]");
					}
					else if("X".equalsIgnoreCase(sundryType)) // Tax Authority
					{
						sql = " select tauth_name, cr_term, credit_prd, acct_code__ap, cctr_code__ap, pay_mode " +
								" from tax_authority where tauth_code = ? ";			
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, sundryCode);
						rs  = pstmt.executeQuery();
						if(rs.next())
						{
							sundryName = checkNull(rs.getString("tauth_name"));
							crTerm = checkNull(rs.getString("cr_term"));
							creditPrd = checkNull(rs.getString("credit_prd"));														
							acctCode = checkNull(rs.getString("acct_code__ap"));
							cctrCode = checkNull(rs.getString("cctr_code__ap"));
							payMode = checkNull(rs.getString("pay_mode"));													
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						sql = " select curr_code from site, finent " +
								" where site.fin_entity = finent.fin_entity and site_code = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, siteCode);
						rs  = pstmt.executeQuery();
						if(rs.next())
						{
							currCode = checkNull(rs.getString("curr_code"));																			
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					}else if("L".equalsIgnoreCase(sundryType)) //  loan party 
					{
						sql = " select party_name, acct_code__ap, cctr_code__ap,curr_code " +
								"from loanparty where party_code = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, sundryCode);
						rs  = pstmt.executeQuery();
						if(rs.next())
						{
							sundryName = checkNull(rs.getString("party_name"));
							acctCode = checkNull(rs.getString("acct_code__ap"));
							cctrCode = checkNull(rs.getString("cctr_code__ap"));														
							currCode = checkNull(rs.getString("curr_code"));
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					}else if("R".equalsIgnoreCase(sundryType)) //forstrategic customer 
					{						
						sql = "select (case when first_name is null then '' else first_name end), " +
								" (case when middle_name is null then '' else middle_name end)," +
								" (case when last_name is null then '' else last_name end),	" +
								" a.curr_code, a.acct_code__ar, a.cctr_code__ar,a.cr_term, a.credit_prd, b.tax_class, b.tax_chap, b.tax_env " +
								" from strg_customer b,customer a " +
								" where b.cust_code = a.cust_code and b.sc_code = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, sundryCode);
						rs  = pstmt.executeQuery();
						if(rs.next())
						{
							fName = checkNull(rs.getString("first_name"));
							mName = checkNull(rs.getString("middle_name"));
							lName = checkNull(rs.getString("last_name"));							
							currCode = checkNull(rs.getString("curr_code"));
							acctCode = checkNull(rs.getString("acct_code__ar"));
							cctrCode = checkNull(rs.getString("cctr_code__ar"));	
							crTerm = checkNull(rs.getString("cr_term"));
							creditPrd = checkNull(rs.getString("credit_prd"));
							taxClass = checkNull(rs.getString("tax_class"));
							taxChap = checkNull(rs.getString("tax_chap"));
							taxEnv = checkNull(rs.getString("tax_env"));							
						}
						rs.close();
						rs = null;
						pstmt.close();						
						pstmt = null;
						System.out.println("---R--taxClass["+taxClass+"]taxChap["+taxChap+"]taxEnv["+taxEnv+"]");
						sundryName = fName.trim()+" "+mName.trim()+" "+lName.trim();
					}							
					valueXmlString.append("<sundry_name>").append("<![CDATA[" + sundryName + "]]>").append("</sundry_name>");
					valueXmlString.append("<acct_code__arap>").append("<![CDATA[" + acctCode + "]]>").append("</acct_code__arap>");
					valueXmlString.append("<cctr_code__arap>").append("<![CDATA[" + cctrCode + "]]>").append("</cctr_code__arap>");
					//To set Taxes from sundry master															
					System.out.println("---Pavan--taxClass["+taxClass+"]taxChap["+taxChap+"]taxEnv["+taxEnv+"]");
					valueXmlString.append("<tax_class>").append("<![CDATA[" + taxClass + "]]>").append("</tax_class>");
					valueXmlString.append("<tax_chap>").append("<![CDATA[" + taxChap + "]]>").append("</tax_chap>");
					valueXmlString.append("<tax_env>").append("<![CDATA[" + taxEnv + "]]>").append("</tax_env>");
				
					if(!("J".equalsIgnoreCase(payableReceivable)))
					{
						if(crTerm == null || crTerm.trim().length() == 0)
						{
							valueXmlString.append("<cr_term>").append("<![CDATA[" + "0" + "]]>").append("</cr_term>");
						}else{
							valueXmlString.append("<cr_term>").append("<![CDATA[" + crTerm + "]]>").append("</cr_term>");
						}
					}
					if(creditPrd == null )
					{
						valueXmlString.append("<credit_days>").append("<![CDATA[" + 0 + "]]>").append("</credit_days>");
					}else{
						valueXmlString.append("<credit_days>").append("<![CDATA[" + creditPrd + "]]>").append("</credit_days>");
					}

					if(payMode == null || payMode.trim().length() == 0)
					{
						valueXmlString.append("<pay_mode>").append("<![CDATA[" + "Q" + "]]>").append("</pay_mode>");
					}else{
						valueXmlString.append("<pay_mode>").append("<![CDATA[" + payMode + "]]>").append("</pay_mode>");
					}				
					
					if( acctCode != null && acctCode.trim().length() > 0 )
					{
						sql = " select descr from accounts where acct_code = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, acctCode);
						rs  = pstmt.executeQuery();
						if(rs.next())
						{
							accountsDescr = checkNull(rs.getString("descr"));						
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;						
						valueXmlString.append("<accounts_descr>").append("<![CDATA[" + accountsDescr + "]]>").append("</accounts_descr>");		
					}
				
					sql = " select descr from currency where curr_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, currCode);
					rs  = pstmt.executeQuery();
					if(rs.next())
					{
						currencyDescr = checkNull(rs.getString("descr"));						
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;											
					valueXmlString.append("<curr_code>").append("<![CDATA[" + currCode + "]]>").append("</curr_code>");					
					valueXmlString.append("<currency_descr>").append("<![CDATA[" + currencyDescr + "]]>").append("</currency_descr>");					
					//Pavan R on 10APR18 [to set tax class and tax chapter from sundry Masters.]
					//taxClass = distCommon.getTaxClass(sundryCode, sundryCode, "", siteCode, conn);
					//taxChap = distCommon.getTaxChap("", "", sundryCode, sundryCode, siteCode, conn);
					//System.out.println("taxClass:["+taxClass+"]taxChap:["+taxChap+"]");
					
					//valueXmlString.append("<tax_class>").append("<![CDATA[" + taxClass + "]]>").append("</tax_class>");
					//alueXmlString.append("<tax_chap>").append("<![CDATA[" + taxChap + "]]>").append("</tax_chap>");
					//valueXmlString.append("<tax_env>").append("<![CDATA[" + taxEnv + "]]>").append("</tax_env>");
					//Pavan R on 10APR18 END
		
					
				}else if(currentColumn.trim().equalsIgnoreCase("sundry_type"))
				{
					sundryType = checkNull(genericUtility.getColumnValue("sundry_type", dom));
					if(sundryType != null && "S".equalsIgnoreCase(sundryType))
					{
						valueXmlString.append("<payable_receivable>").append("<![CDATA[" + "P" + "]]>").append("</payable_receivable>");
					}
					else if(sundryType != null && "O".equalsIgnoreCase(sundryType))
					{
						valueXmlString.append("<sundry_code>").append("<![CDATA[" + " " + "]]>").append("</sundry_code>");
						valueXmlString.append("<payable_receivable>").append("<![CDATA[" + "J" + "]]>").append("</payable_receivable>");																																				
					}else
					{
						valueXmlString.append("<sundry_code>").append("<![CDATA[" + sundryCode + "]]>").append("</sundry_code>");
						valueXmlString.append("<payable_receivable>").append("<![CDATA[" + "R" + "]]>").append("</payable_receivable>");						
					}	
					
					
				}else if(currentColumn.trim().equalsIgnoreCase("payable_receivable"))
				{
					payableReceivable = checkNull(genericUtility.getColumnValue("payable_receivable", dom));					
					taxClass = checkNull(genericUtility.getColumnValue("tax_class", dom));
					taxChap = checkNull(genericUtility.getColumnValue("tax_chap", dom));
					taxEnv = checkNull(genericUtility.getColumnValue("tax_env", dom));	
					System.out.println("---1319--taxClass["+taxClass+"]taxChap["+taxChap+"]taxEnv["+taxEnv+"]");
					if (payableReceivable != null && "R".equalsIgnoreCase(payableReceivable))
					{
						valueXmlString.append("<tax_class protect = \"1\">").append("<![CDATA[" + taxClass + "]]>").append("</tax_class>");
						valueXmlString.append("<tax_chap protect = \"1\">").append("<![CDATA[" + taxChap + "]]>").append("</tax_chap>");
						valueXmlString.append("<tax_env protect = \"1\">").append("<![CDATA[" + taxEnv + "]]>").append("</tax_env>");						
					}
					else
					{						
						valueXmlString.append("<tax_class protect = \"0\">").append("<![CDATA[" + taxClass + "]]>").append("</tax_class>");
						valueXmlString.append("<tax_chap protect = \"0\">").append("<![CDATA" + taxChap + "[]]>").append("</tax_chap>");
						valueXmlString.append("<tax_env protect = \"0\">").append("<![CDATA[" + taxEnv + "]]>").append("</tax_env>");								
					}
				}
				else if(currentColumn.trim().equalsIgnoreCase("cr_term"))
				{
					crTerm = checkNullAndTrim(genericUtility.getColumnValue("cr_term", dom));
					sql = " Select cr_days from crterm where cr_term = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, crTerm);
					rs  = pstmt.executeQuery();
					if(rs.next())
					{
						crDays = rs.getInt("cr_days");						
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					valueXmlString.append("<credit_days>").append("<![CDATA[" + crDays + "]]>").append("</credit_days>");
				}
				else if(currentColumn.trim().equalsIgnoreCase("curr_code"))
				{
					currCode= checkNull(genericUtility.getColumnValue("curr_code", dom));
					sql = " Select descr from currency where curr_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, currCode);
					rs  = pstmt.executeQuery();
					if(rs.next())
					{
						currencyDescr = checkNull(rs.getString("descr"));						
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					valueXmlString.append("<currency_descr>").append("<![CDATA[" + currencyDescr + "]]>").append("</currency_descr>");
				}
				else if(currentColumn.trim().equalsIgnoreCase("acct_code__arap"))
				{
					acctCodeArAp= checkNull(genericUtility.getColumnValue("acct_code__arap", dom));
					sql = " Select descr from accounts where acct_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, acctCodeArAp);
					rs  = pstmt.executeQuery();
					if(rs.next())
					{
						accountsDescr = checkNull(rs.getString("descr"));						
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					valueXmlString.append("<accounts_descr>").append("<![CDATA[" + accountsDescr + "]]>").append("</accounts_descr>");
				}
				else if(currentColumn.trim().equalsIgnoreCase("bank_code"))
				{
					bankCode= checkNull(genericUtility.getColumnValue("bank_code", dom));
					sql = " select bank_name from bank where bank_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, bankCode);
					rs  = pstmt.executeQuery();
					if(rs.next())
					{
						bankName = checkNull(rs.getString("bank_name"));						
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					valueXmlString.append("<bank_bank_name>").append("<![CDATA[" + bankName + "]]>").append("</bank_bank_name>");										
				}				
				
				valueXmlString.append("</Detail1>");
				break;
			case 2:
				valueXmlString.append("<Detail2>");
				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				//valueXmlString.append("<Detail2 domID='"+(domId++)+"'>");
				childNodeListLength = childNodeList.getLength();
				do
				{   
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					ctr ++;
				}
				while(ctr < childNodeListLength  && ! childNodeName.equals(currentColumn));
				if (currentColumn.equalsIgnoreCase("itm_default"))
				{
					System.out.println("@@@@ itm_default called............");
					lineNo = checkNull(genericUtility.getColumnValue("line_no", dom));
					
					if(lineNo != null && lineNo.trim().length() > 0) 
					{
						valueXmlString.append("<line_no>").append("<![CDATA[" + lineNo + "]]>").append("</line_no>");
					}	
					String allowDetEditable = finCommon.getFinparams("999999", "ALLOW_EDITABLE_MVOUC", conn);
				
					if("NULLFOUND".equalsIgnoreCase(allowDetEditable) || allowDetEditable == null)
					{
						allowDetEditable = "N"; 
					}
					//Added By PriyankaC on 15MAY2018 to set default employee code from login code.[START]
					logInEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
					System.out.println("logInEmpCode.. " + logInEmpCode);
					sql = " Select emp_fname,emp_lname from employee where emp_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, logInEmpCode);
					rs  = pstmt.executeQuery();
					if(rs.next())
					{
						fName = checkNull(rs.getString("emp_fname"));	
						lName = checkNull(rs.getString("emp_lname"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					valueXmlString.append("<emp_code>").append("<![CDATA[" + logInEmpCode + "]]>").append("</emp_code>");
					valueXmlString.append("<emp_fname>").append("<![CDATA[" + fName + "]]>").append("</emp_fname>");
					valueXmlString.append("<emp_lname>").append("<![CDATA[" + lName + "]]>").append("</emp_lname>");
					//System.out.println("empCode... " + empCode);
					//Added By PriyankaC on 15MAY2018 to set default employee code from login code.[END]
					contractId  = checkNull(genericUtility.getColumnValue("contract_id", dom));	
					valueXmlString.append("<contract_id>").append("<![CDATA[" + contractId + "]]>").append("</contract_id>");
					taxClass = checkNull(genericUtility.getColumnValue("tax_class", dom1));
					taxChap = checkNull(genericUtility.getColumnValue("tax_chap", dom1));
					taxEnv = checkNull(genericUtility.getColumnValue("tax_env", dom1));	
					System.out.println("---Detail--taxClass["+taxClass+"]taxChap["+taxChap+"]taxEnv["+taxEnv+"]");
					if("Y".equalsIgnoreCase(allowDetEditable))
					{
						valueXmlString.append("<tax_class protect = \"0\">").append("<![CDATA[" + taxClass + "]]>").append("</tax_class>");
						valueXmlString.append("<tax_chap protect = \"0\">").append("<![CDATA[" + taxChap + "]]>").append("</tax_chap>");
						valueXmlString.append("<tax_env protect = \"0\">").append("<![CDATA[" + taxEnv + "]]>").append("</tax_env>");
					}
					else						
					{
						valueXmlString.append("<tax_class protect = \"1\">").append("<![CDATA[" + taxClass + "]]>").append("</tax_class>");
						valueXmlString.append("<tax_chap protect = \"1\">").append("<![CDATA[" + taxChap + "]]>").append("</tax_chap>");
						valueXmlString.append("<tax_env protect = \"1\">").append("<![CDATA[" + taxEnv + "]]>").append("</tax_env>");
					}									
				}
				else if (currentColumn.equalsIgnoreCase("acct_code"))
				{
					acctCode  = checkNull(genericUtility.getColumnValue("acct_code", dom));
					sql = " Select descr from accounts where acct_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, acctCode);
					rs  = pstmt.executeQuery();
					if(rs.next())
					{
						descr = checkNull(rs.getString("descr"));						
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					valueXmlString.append("<descr>").append("<![CDATA[" + descr + "]]>").append("</descr>");
				}else if (currentColumn.equalsIgnoreCase("emp_code"))
				{
					empCode  = checkNull(genericUtility.getColumnValue("emp_code", dom));
					sql = " Select emp_fname,emp_lname from employee where emp_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, empCode);
					rs  = pstmt.executeQuery();
					if(rs.next())
					{
						fName = checkNull(rs.getString("emp_fname"));	
						lName = checkNull(rs.getString("emp_lname"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					//valueXmlString.append("<>").append("<![CDATA[" +  + "]]>").append("</>");
					valueXmlString.append("<emp_fname>").append("<![CDATA[" + fName + "]]>").append("</emp_fname>");
					valueXmlString.append("<emp_lname>").append("<![CDATA[" + lName + "]]>").append("</emp_lname>");
					
					sql = " select dept_code  from employee where emp_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, empCode);
					rs  = pstmt.executeQuery();
					if(rs.next())
					{
						deptCode = checkNull(rs.getString("dept_code"));	
						
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					valueXmlString.append("<dept_code>").append("<![CDATA[" + deptCode + "]]>").append("</dept_code>");
				}
				
				valueXmlString.append("</Detail2>");
				break;
			//Added by Amol S on 20 Feb-25 to apply item-change on Asset_Code Field --START
			case 3:
			{
		        BaseLogger.log("3", null, null, "Inside the case 3	");

		        
		        valueXmlString.append("<Detail3>");
				parentNodeList = dom.getElementsByTagName("Detail3");
			    parentNode = parentNodeList.item(0);
			    childNodeList = parentNode.getChildNodes();
			    ctr = 0;
			    childNodeListLength = childNodeList.getLength();

			    do
			    {   
			        childNode = childNodeList.item(ctr);
			        childNodeName = childNode.getNodeName();
			        if(childNodeName.equals(currentColumn))
			        {
			            if(childNode.getFirstChild() != null)
			            {
			                // Processing for ASSET_CODE
			                if(currentColumn.trim().equalsIgnoreCase("ASSET_CODE"))
			                {
			                	System.out.println("DOM in case 3 :---->>["+genericUtility.serializeDom(dom).toString()+"]");

			                    String assetCode = checkNull(genericUtility.getColumnValue("asset_code", dom));
			    		        BaseLogger.log("3", null, null, "ASSET CODE ::	"+assetCode );

			                    sql = "SELECT DESCR FROM asset_register WHERE asset_code = ?";
			                    pstmt = conn.prepareStatement(sql);
			                    pstmt.setString(1, assetCode);
			                    rs = pstmt.executeQuery();
			                    
			                    String assetDescr = "";
			                    if(rs.next())
			                    {
			                        assetDescr = checkNull(rs.getString("DESCR"));
			                    }
			                    
			                    rs.close();
			                    pstmt.close();

			                    valueXmlString.append("<descr>").append("<![CDATA[").append(assetDescr).append("]]>").append("</descr>");
			                }
			            }
			        }
			        ctr++;
			    } while(ctr < childNodeListLength && !childNodeName.equals(currentColumn));

			    valueXmlString.append("</Detail3>");
			}
			//Added by Amol S on 20-Feb-25 to apply item-change on Asset_Code field --END
				
			}//switch
			valueXmlString.append("</Root>");
			System.out.println("------ItemChanged::valueXmlString["+valueXmlString+"]");
		}catch(Exception e)
		{
		}
		//Add by Ajay on 02/05/18:START
				finally {
					try {
						if (conn != null) {
							if (rs != null) {
								rs.close();
								rs = null;
							}
							if (pstmt != null) {
								pstmt.close();
								pstmt = null;
							}
							conn.close();
						}
						conn = null;
					} catch (Exception d) {
						d.printStackTrace();
						throw new ITMException(d);
					}
				}
				//Add by Ajay on 02/05/18:END
		return valueXmlString.toString();
	}
	
	private String  isAcctDept(String acctCode, String deptCode, String tranSer, Connection conn)
	{
		String errCode = "", sql = "", acctSpec = "";
		int cnt = 0;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		FinCommon finCommon = null;
		try
		{
			finCommon = new FinCommon();
			if(deptCode != null && deptCode.trim().length() > 0)
			{
				sql = " select count(1) as cnt from department where dept_code = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, checkNull(deptCode));			
				rs = pstmt.executeQuery();
				if (rs.next()) {
					cnt = rs.getInt("cnt");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				if(cnt == 0 )
				{
					errCode = "VMDEPT1";							
				}
				else
				{
					acctSpec = finCommon.getFinparams("999999", "ACCT_SPECIFIC_DEPT", conn);					
					if(acctSpec != null && "Y".equalsIgnoreCase(acctSpec))
					{
						sql = "select count(1) as cnt from accounts_dept where acct_code = ? and dept_code = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, checkNull(acctCode));
						pstmt.setString(2, checkNull(deptCode));
						rs = pstmt.executeQuery();
						if (rs.next()) {
							cnt = rs.getInt("cnt");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						if(cnt == 0 )
						{
							sql = "select count(1) as cnt from accounts_dept where acct_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, checkNull(acctCode));
							rs = pstmt.executeQuery();
							if (rs.next()) {
								cnt = rs.getInt("cnt");
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if(cnt > 0 )
							{
								errCode = "VMDEPT2";
							}
							else if(cnt == 0)
							{
								if(deptCode != null && "Y".equalsIgnoreCase(deptCode))
								{
									errCode = "VMDEPT2";
								}
							}
								
						}
					}
				}
			}			
		}catch (SQLException se)
		{
			System.out.println("SQLException :RetainerContractReleasePrc :getData(Document dom, Document dom2, String winName, String xtraParams):" + se.getMessage() + ":");			
			se.printStackTrace();
			
		} catch (Exception e)
		{
			System.out.println("Exception :RetainerContractReleasePrc :getData(Document dom, Document dom2, String winName, String xtraParams):" + e.getMessage() + ":");
			//this.errString = genericUtility.createErrorString(e);
			e.printStackTrace();			
		} 	
		return errCode;
	}
	
	private String errorType(Connection conn, String errorCode) throws ITMException {
		String msgType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try {
			String sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				msgType = rs.getString("MSG_TYPE");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		} catch (Exception ex) {
			ex.printStackTrace();
			throw new ITMException(ex);
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return msgType;
	}
	
	private String findValue(Connection conn, String columnName ,String tableName, String columnName2, String value) throws  ITMException, RemoteException
	{

		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		String findValue = "";

		try
		{			
			sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"  = ?";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,value);
			rs = pstmt.executeQuery();

			if(rs.next())
			{					
				findValue = rs.getString(columnName);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;	        
		}
		catch(Exception e)
		{
			System.out.println("Exception in findValue ");
			e.printStackTrace();
			throw new ITMException(e); 
		}

		System.out.println("returning String from findValue ");
		return findValue;
	}
	
	private String checkNull(String str) {
		if (str == null) {
			return "";
		} else {
			return str;
		}

	}
	private String checkNullAndTrim(String inputVal)
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}
	public String getParentColumnValue(String currColumn, Document dom, String formNo)throws ITMException
	{
		
		NodeList parentNodeList=null;        
        Node parentNode=null;        
        String Value = "";
        try
        {        	
            E12GenericUtility genericUtility= new  E12GenericUtility();
            parentNodeList = dom.getElementsByTagName("Detail"+formNo);
            int childNodeListLength = parentNodeList.getLength();
            for(int ctr = 0; ctr < childNodeListLength; ctr++)
            {
                parentNode = parentNodeList.item(ctr);
                Value  = genericUtility.getColumnValueFromNode(currColumn, parentNode);
                break;

            } // end for
        }//END TRY
        catch(Exception e)
        {
            System.out.println("DistCommon::getParentColumnValue::Exception ::"+e);
            e.printStackTrace();
            throw new ITMException(e);
        }
        return Value;		
	}
}
